/*
 * @(#)ConceptualERDiagram.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.cer.model.CEREntitySet;
import ch.hslu.cm.cer.model.CERConnection;
import ch.hslu.cm.cer.model.ConceptualERModel;
import ch.hslu.cm.cer.model.CERISA;
import ch.hslu.cm.cer.model.CERRelationshipSet;
import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
/**
 * A General CEREntitySet-Relationship Diagram.
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18  Created.
 */
public class ConceptualERDiagram extends AbstractDiagram {
    public final static Color
    ENTITY_SET_FILL_COLOR = new Color(0x90c6ff),
    ENTITY_SET_STROKE_COLOR = new Color(0x1b1b1b),
    ENTITY_SET_TEXT_COLOR = new Color(0x030303),
    RELATIONSHIP_SET_FILL_COLOR = new Color(0x90c6ff),
    RELATIONSHIP_SET_STROKE_COLOR = new Color(0x1b1b1b),
    RELATIONSHIP_SET_TEXT_COLOR = new Color(0x030303),
    ATTRIBUTE_FILL_COLOR = new Color(0x90c6ff),
    ATTRIBUTE_STROKE_COLOR = new Color(0x1b1b1b),
    ATTRIBUTE_TEXT_COLOR = new Color(0x030303),
    ISA_FILL_COLOR = new Color(0x90c6ff),
    ISA_STROKE_COLOR = new Color(0x1b1b1b),
    ISA_TEXT_COLOR = new Color(0x030303),
    CONNECTION_STROKE_COLOR = new Color(0x1b1b1b)
    ;
   public final static double DIAGRAM_STROKE_WIDTH = 2d;
    
    public final static int OBJECT_LAYER = 0;
    public final static int LINK_LAYER = 1;
    
    /** Creates a new instance. */
    public ConceptualERDiagram() {
        this(new ConceptualERModel());
    }
    /*
    public void setLocale(Locale l) {
       getERModel().setLocale(l);
    }*/
    
    public ConceptualERDiagram(ConceptualERModel simulation) {
        setSimulation(simulation);
    }
    public ConceptualERModel getERModel() {
        return (ConceptualERModel) getSimulation();
    }
    
    protected DiagramFigure createDiagramFigure(SimulatedElement simElem) {
        switch (simElem.getSimulatedConcept()) {
            case ConceptualERModel.ENTITY_SET : {
                CEREntitySetFigure f = new CEREntitySetFigure();
                f.setModel((CEREntitySet) simElem);
                return f;
            }
            case ConceptualERModel.RELATIONSHIP_SET : {
                CERRelationshipSetFigure f = new CERRelationshipSetFigure();
                f.setModel((CERRelationshipSet) simElem);
                return f;
            }
            case ConceptualERModel.ISA : {
                CERISAFigure f = new CERISAFigure();
                f.setModel((CERISA) simElem);
                return f;
            }
            case ConceptualERModel.RELATIONSHIP :
            case ConceptualERModel.GENERALIZATION :
            case ConceptualERModel.SPECIALIZATION :
            {
                CERConnectionFigure f = new CERConnectionFigure();
                f.setModel((CERConnection) simElem);
                return f;
            }
            default :
                return null;
        }
    }
}
